/****** Object:  Trigger [TRG_RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA_PENDENCIA]    Script Date: 08/08/2012 10:00:52 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA_PENDENCIA]'))
DROP TRIGGER [dbo].[TRG_RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA_PENDENCIA]
GO
GO
CREATE TRIGGER [dbo].[TRG_RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA_PENDENCIA] ON [dbo].[RC_CONC_PDV_VD_TEF] 
FOR INSERT,UPDATE
AS
BEGIN TRY
	IF NOT EXISTS( SELECT 
					i.CD_EMP 
			   FROM 
					RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA p INNER JOIN  INSERTED i ON
					p.CD_EMP = i.CD_EMP AND
					p.CD_CTR_LOTE  = i.CD_CTR_LOTE AND
					p.CD_FILIAL = i.CD_FILIAL AND
					p.CD_VD = i.CD_VD AND
					p.CD_CTR = i.CD_CTR)
		begin
			INSERT INTO RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA
			(CD_EMP,
			CD_CTR_LOTE,
			CD_FILIAL,
			CD_VD,
			CD_CTR,
			DT_CAD,
			FLAG_RESPOSTA)
			SELECT 
				i.CD_EMP,
				i.CD_CTR_LOTE,
				i.CD_FILIAL,
				i.CD_VD,
				i.CD_CTR,
				GETDATE(),
				0
			FROM
				INSERTED i 
		end
END TRY
BEGIN CATCH
	DECLARE @mensagemErro	varchar(250);
	DECLARE @severidadeErro int;
	DECLARE @estadoErro		int;
	SELECT	@mensagemErro	=  ERROR_MESSAGE(), 
		@severidadeErro = ERROR_SEVERITY(), 
		@estadoErro		= ERROR_STATE();
	RAISERROR (@mensagemErro , @severidadeErro , @estadoErro ); 
END CATCH


